// MovieClusterStatus.java
// Version 0.4 
// Last Updated: 10/16/2000
// Used by RecommendationManager

// Change Log
// RP101600 - Standardize naming, tab spacing, and commenting.


package Alkindi.BusinessServices.BeanImpl;

import java.util.*;
import java.sql.*;
import java.math.*;
import oracle.jdbc.driver.*;

import Alkindi.BusinessServices.*;

public class MovieClusterStatus {


	static int MaxNum_movie_cluster = 8; // this value will be stored in cache manager(next cut); 
	
	public int[] getAorD() 
	throws AlkExcept{
	    int[] gAD = new int [MaxNum_movie_cluster];

		for (int f = 0;f < MaxNum_movie_cluster;f++ ){
			gAD[f]=0;
		}
		
		try{
			AlkConn ac = new AlkConn();
			Connection con = ac.getConnection();
			CallableStatement cs = con.prepareCall("{ call pkg_ALKINDI_RECOMMENDATION.sp_SEL_All_PC_Status(?,?)}");  
			cs.registerOutParameter(1, OracleTypes.CURSOR );
			cs.registerOutParameter(2, Types.INTEGER );	
			cs.executeQuery();
			ResultSet rs = ( (OracleCallableStatement)cs).getCursor(1); 
			int error = cs.getInt(2);
			
			switch (error){

		    case  0:
				while (rs.next()){
					gAD[rs.getInt ("PRODUCT_CLUSTER_ID")]= rs.getInt("PRODUCT_CLUSTER_ACTIVE");
				}	
			break;

		    case -1:
				throw new AlkExcept("Error in Retrieving Values",6012);
			}
			rs.close();
			cs.close();
			con.close();
		} //END try

		catch(SQLException sqlexcept){
			throw new AlkExcept("SQL Exception in getAorD in MovieClusterStatus. Message: " + sqlexcept.getMessage(), 6004);
		}

		return gAD;
	}
}
